function cellDiv(name_m,name_d)

%mothercell divides into 2 daughtercells: a reincarnation of itself and a
%new cell. The amounts of the molecules present in the daughter cells will
%approximately be the same as the mother cell 
%(random variations because of cell division process) 
%
% Copyright 2008 Nick Van Damme


global model

m = sbioselect('Type', 'compartment', 'Name', name_m);
mother = m(1);
m = sbioselect('Type', 'compartment', 'Name', name_d);
daughter = m(1);

changerate = 0.4;

%copy all compartments
for k=1:length(mother.compartments)
    % copy all species
    for l=1:length(mother.compartments(k).Species)
        %gene copy number stays the same
        if isempty(strfind(mother.compartments(k).Species(l).Name, 'Gene'))
            mother.compartments(k).species(l).InitialAmount = max(mother.compartments(k).species(l).InitialAmount ...
                + mother.compartments(k).species(l).InitialAmount*changerate*randn(1),0);
            daughter.compartments(k).species(l).InitialAmount = max(mother.compartments(k).species(l).InitialAmount ...
                + mother.compartments(k).species(l).InitialAmount*changerate*randn(1),0);
        end
    end
end
%copy all species
for m=1:length(mother.Species)
    %gene copy number stays the same
    if isempty(strfind(mother.species(m).Name, 'Gene'))
        mother.species(m).InitialAmount = max(mother.species(m).InitialAmount ...
                + mother.species(m).InitialAmount*changerate*randn(1),0);
        daughter.species(m).InitialAmount = max(mother.species(m).InitialAmount ...
                + mother.species(m).InitialAmount*changerate*randn(1),0);
    end
end